﻿addIndent = function( smallIndent, indent )
{
	var indent_txt = "";
	
	// small indent
	for (var i=0; i<smallIndent; i++)
	{
		indent_txt += "\t";
	}// for:  smallIndent
	
	// big indent
	for (var i=0; i<indent; i++)
	{
		indent_txt += "\t\t\t\t\t";
	}// for:  indent
	
	// return the result
	return indent_txt;
}// addIndent()





writeScript = function( script_obj , scriptData, smallIndent, indent, firstCommand )
{
	var scriptName = scriptData.scriptName;
	var mainSprite = scriptData.mainSprite;
	
	// add code to run "talkEvents"
	if(scriptData.scriptName == "talkEvents")
	{
		script_obj.txt += '\n\n\n';
		
		script_obj.txt += '// talk program \n';
		script_obj.txt += '_this.talk = function(){ \n';
		script_obj.txt += '	talkEvents.runEvent(0); \n';
		script_obj.txt += '}// talk() \n';
		script_obj.txt += '\n';
		script_obj.txt += '// talkEvents \n';
	}// if:  talkEvents
	
	
	
	// include script system
	script_obj.txt += '#include "functions/scriptSystem.as" \n';
	
	
	
	if(!firstCommand)
	{// if:  This is NOT the 1st event
		script_obj.txt += addIndent( smallIndent, indent );
	}// if:  This is NOT the 1st event
	
	// header
	script_obj.txt += scriptName+"= makeScriptSystem("+mainSprite+");		"+scriptName+".defineScript(["+"\n";
	smallIndent++;
	
	// iterate through the events
	for(var s=0; s<scriptData.length; s++)
	{
		var thisEvent = scriptData[s];
		if(s==0)
		{
			var firstEvent = true;
		}else{
			var firstEvent = false;
		}
		writeEvent( script_obj, thisEvent, smallIndent, indent, firstEvent );
	}// for:  each event
	
	// footer
	smallIndent--;
	script_obj.txt += addIndent( smallIndent, indent );
	script_obj.txt += "}]);	// "+scriptName+" script";		// close the last event within the script,  then close the script
	
	
	
	// add code to run "autoEvents"
	if(scriptData.scriptName == "autoEvents")
	{
		script_obj.txt += '\n\n\n\n';
		
		script_obj.txt += 'waitForPlayer = function(){ \n';
		script_obj.txt += '	if(PLAYER_MC._x != undefined){ \n';
		script_obj.txt += '		autoEvents.runEvent(); \n';
		script_obj.txt += '		clearInterval( playerWait ); \n';
		script_obj.txt += '	}// if:  player exists \n';
		script_obj.txt += '}// waitForPlayer() \n';
		script_obj.txt += 'var playerWait = setInterval( waitForPlayer, 34 );';
	}// if:  autoEvents
}// writeScript()





writeEvent = function( script_obj , thisEvent, smallIndent, indent, firstEvent )
{
	if(!firstEvent)
	{// if:  This is NOT the 1st event
		// close the previous event
		script_obj.txt += addIndent( smallIndent, indent );
		script_obj.txt += "},"+"\n";
	}// if:  This is NOT the 1st event
	
	// header
	script_obj.txt += addIndent( smallIndent, indent );
	script_obj.txt += "function(){		";
	
	
	// iterate through commands
	if(thisEvent.length > 0)
	{// if:  There are any events
		indent++;
		
		// event 0		(don't apply an indent to this line)
		var thisCommand = thisEvent[0];
		writeCommand( script_obj, thisCommand, smallIndent, indent );
		
		// events 1 - All
		for(var c=1; c<thisEvent.length; c++)
		{
			script_obj.txt += addIndent( smallIndent, indent );
			var thisCommand = thisEvent[c];
			writeCommand( script_obj, thisCommand, smallIndent, indent );
		}// for:  each command
		
		indent--;
	}// if:  There are any events
}// writeEvent()





writeCommand = function( script_obj , thisCommand, smallIndent, indent )
{
	switch( thisCommand.type )
	{
		case "script":
			// parse the script
			trace("indent: "+indent);
			writeScript( script_obj , thisCommand, smallIndent, indent, true );
			// immediately run this script
			script_obj.txt += "\n"+addIndent( smallIndent, indent );
			script_obj.txt += thisCommand.scriptName+".runEvent(0);"
		break;
		case "nextEvent":
			script_obj.txt += thisCommand.callback+".nextEvent();";
		break;
		
		case "textBox":
			// construct face
			if(thisCommand.face == ""){
				var face = 'null';
			}else{
				var face = '"'+thisCommand.face+'"';
			}
			
			// construct choices
			if(thisCommand.choices.length > 0)
			{
				var choices = "[";
				for(var c=0; c<thisCommand.choices.length; c++)
				{
					if(c!=0)
						choices += ", ";
					
					choices += thisCommand.choices[c];
				}
				choices += "]";
			}else{
				var choices = "null";
			}
			
			// replace carriage returns with: \n
			var message = thisCommand.message;
			var enterCode = String.fromCharCode(13);
			while(message.indexOf(enterCode) != -1 )
			{
				var enterAt = message.indexOf(enterCode);
				message = message.substring( 0, enterAt ) + "\\n" + message.substr( enterAt+1 );
			}// while:  there is a carriage return in the message
			
			script_obj.txt += 'event_message( '+thisCommand.callback+', "'+message+'", '+thisCommand.position+', '+face+', '+choices+' );';
		break;
		case "balloon":
			// replace carriage returns with: \n
			var message = thisCommand.message;
			var enterCode = String.fromCharCode(13);
			while(message.indexOf(enterCode) != -1 )
			{
				var enterAt = message.indexOf(enterCode);
				message = message.substring( 0, enterAt ) + "\\n" + message.substr( enterAt+1 );
			}// while:  there is a carriage return in the message
			script_obj.txt += 'event_talk( '+thisCommand.callback+', "'+message+'", '+thisCommand.sprite+' )';
		break;
		
		case "moveTo":
			script_obj.txt += 'event_moveTo( '+thisCommand.callback+',  '+thisCommand.x+',  '+thisCommand.y+',  '+thisCommand.autoPose+', '+thisCommand.speed+',  '+thisCommand.sprite+' );';
		break;
		case "move":
			script_obj.txt += 'event_move( '+thisCommand.callback+',  '+thisCommand.x+',  '+thisCommand.y+',  '+thisCommand.autoPose+', '+thisCommand.speed+',  '+thisCommand.sprite+' );';
		break;
		
		case "lookAt":
			script_obj.txt += thisCommand.sprite+'.image_mc.lookAt( '+thisCommand.target+' );';
		break;
		case "look":
			script_obj.txt += thisCommand.sprite+'.image_mc.setDirection( "'+thisCommand.direction+'" );';
		break;
		
		case "charset":
			script_obj.txt += thisCommand.sprite+'.image_mc.setCharset( "'+thisCommand.charset+'" );';
		break;
		case "anim":
			script_obj.txt += thisCommand.sprite+'.image_mc.setAnim( '+thisCommand.anim+' );';
		break;
		case "pose":
			script_obj.txt += thisCommand.sprite+'.image_mc.setPose( '+thisCommand.pose+' );';
		break;
		case "appearance":
			script_obj.txt += thisCommand.sprite+'.image_mc.setAll( "'+thisCommand.charset+'", '+thisCommand.pose+', '+thisCommand.direction+', '+thisCommand.anim+', '+thisCommand.frame+' );';
		break;
		
		case "wait":
			script_obj.txt += 'event_wait( '+thisCommand.callback+', '+thisCommand.seconds+' );';
		break;
		case "waitForScript":
			script_obj.txt += 'if('+thisCommand.waitForScript+'.isDone){  '+thisCommand.resumeScript+'.nextEvent();  }else{  '+thisCommand.waitForScript+'.done = function(){'+thisCommand.resumeScript+'.nextEvent();}  }';
		break;
		
		case "music":
			script_obj.txt += 'MUSIC.play( "'+thisCommand.music+'" );';
		break;
		case "sound":
			script_obj.txt += 'SOUND.play( "'+thisCommand.sound+'" );';
		break;
		
		case "actionscript":
			// divide actionscript by carriage returns
			var enterCode = String.fromCharCode(13);
			var actionscript_array = thisCommand.actionscript.split( enterCode );
			// write 1st line
			script_obj.txt += actionscript_array[0];
			// write the rest of the lines with indenting
			for(var a=1; a<actionscript_array.length; a++)
			{
				script_obj.txt += "\n" + addIndent( smallIndent, indent );
				script_obj.txt += actionscript_array[a];
			}// for:  actionscript_array		(1 - ~)
		break;
		case "comment":
			// divide comment by carriage returns
			var enterCode = String.fromCharCode(13);
			var comment_array = thisCommand.comment.split( enterCode );
			// write 1st line
			script_obj.txt += "// "+comment_array[0];
			// write the rest of the lines with indenting
			for(var a=1; a<comment_array.length; a++)
			{
				script_obj.txt += "\n" + addIndent( smallIndent, indent );
				script_obj.txt += "// "+comment_array[a];
			}// for:  comment_array		(1 - ~)
		break;
		
		case "teleport":
			script_obj.txt += 'event_teleport( "'+thisCommand.map+'", '+thisCommand.x+', '+thisCommand.y+' );';
		break;
		case "pause":
			script_obj.txt += 'LOOP.pauseSet( "'+thisCommand.target+'", '+thisCommand.pause+' );';
		break;
		
		case "transition":
			script_obj.txt += 'TRANSITION_MC.'+thisCommand.effect+'();';
			script_obj.txt += "\n" + addIndent( smallIndent, indent );
			script_obj.txt += 'TRANSITION_MC.onTransitionDone = function(){	'+thisCommand.callback+'.nextEvent();		}// after transition';
		break;
	}// switch:  type
	
	script_obj.txt += "\n";
}// writeCommand()